CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_biometria' and column_name='cd_cli') THEN 
		ALTER TABLE rc_cli_biometria ALTER COLUMN cd_cli TYPE integer;
	END IF; 
		

	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_biometria' and column_name='biometria') THEN 
		ALTER TABLE rc_cli_biometria ALTER COLUMN biometria TYPE text;
	END IF; 
	

	IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_biometria' and column_name='dt_cad') THEN 
		ALTER TABLE rc_cli_biometria ADD COLUMN dt_cad timestamp without time zone;
	END IF; 
	
	
	IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'rc_cli_biometria' and column_name='cd_bio') THEN 
		ALTER TABLE rc_cli_biometria ADD COLUMN cd_bio integer not null DEFAULT 1;
	END IF; 
	

	---CONSTRAINT----------------------------------------------------------------------------------------------------------
	
	IF EXISTS (SELECT 1 from pg_indexes WHERE tablename= 'rc_cli_biometria' and LOWER(INDEXNAME)='rc_cli_biometria_pkey') THEN 
		ALTER TABLE rc_cli_biometria DROP CONSTRAINT rc_cli_biometria_pkey;
	END IF;
	
	-- Adicionar a restrição de chave primária
	ALTER TABLE rc_cli_biometria ADD CONSTRAINT rc_cli_biometria_pkey PRIMARY KEY (cd_cli, cd_emp, cd_bio);
	
	
	IF NOT EXISTS (SELECT 1 from information_schema.table_constraints WHERE table_name= 'rc_cli_biometria' and LOWER(constraint_name)='fk_rc_cli_biometria') THEN 
		
		-- Adicionar a restrição de chave estrangeira
		ALTER TABLE rc_cli_biometria ADD CONSTRAINT fk_rc_cli_biometria FOREIGN KEY (cd_emp, cd_cli) REFERENCES rc_cli (cd_emp, cd_cli);
	END IF;
	
	
	--INDEX---------------------------------------------------------------------------------------------------
	
	IF EXISTS (select 1 from pg_indexes where LOWER(indexname) ilike 'idx_rc_cli_biometria_emp_cli') THEN 
		DROP INDEX idx_rc_cli_biometria_emp_cli;
	END IF;
	
	CREATE INDEX idx_rc_cli_biometria_emp_cli ON rc_cli_biometria USING btree (cd_emp, cd_cli, cd_bio);
	

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();